<?php

require_once('tcpdf_include.php');
require_once('tcpdf.php');
include_once("../../lib/konfig.php");

$id = $_GET['id'];
$leftMargin = 1;
$topMargin = 1;
$rightMargin = 1;
$bottomMargin = 1;
$query = "call nomer_lot($id);";
$MySQLi = new MySQLi($strDBHostName, $strDBUsername, $strDBPassword, $strDBName);
$data = $MySQLi->query($query);
$custom_format = array(100, 80); // Landscape: lebar 100mm, tinggi 80mm

// Inisialisasi TCPDF
$pdf = new TCPDF('L', 'mm', $custom_format, true, 'UTF-8', false); // 'L' untuk landscape
$pdf->SetMargins($leftMargin, $topMargin, $rightMargin);
$pdf->SetAutoPageBreak(false, $bottomMargin);
$pdf->AddPage();

$style = array(
    'position' => '',
    'align' => '',
    'stretch' => true,
    'fitwidth' => false,
    'cellfitalign' => '',
    'border' => true,
    'hpadding' => 'auto',
    'vpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => array(255, 255, 255),
    'text' => true,
    'font' => 'helvetica',
    'fontsize' => 20,
    'stretchtext' => 4
);

// Lebar dan tinggi yang tersedia setelah margin
$available_width = 100 - ($leftMargin + $rightMargin);  // 100 mm - 2 mm
$available_height_per_barcode = (80 - ($topMargin + $bottomMargin)) / 2;  // 80 mm - 2 mm, dibagi 2

// Perulangan untuk data yang dihasilkan, memastikan dua barcode per halaman
foreach ($data as $index => $d) {
    if ($index % 2 == 0 && $index > 0) {
        $pdf->AddPage(); // Tambah halaman baru setelah dua barcode        
    }

    $yPosition = $index % 2 == 0 ? $topMargin : $topMargin + $available_height_per_barcode;

    // Menulis barcode
    $pdf->write1DBarcode($d['lotfg'], 'C128', $leftMargin, $yPosition, $available_width, $available_height_per_barcode - 5, 0.6, $style, 'N');

    // Menulis warna di bawah barcode
    $pdf->SetXY($leftMargin, $yPosition + $available_height_per_barcode - 5);
    $pdf->Cell($available_width, 5, $d['warna'], 1, 1, 'C');
}

$pdf->Output('lotnumber.pdf', 'I');
