<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<main id="main" class="main">
    <style>
        th,
        td {
            white-space: wrap;
            vertical-align: top;
        }

        div.dataTables_wrapper {
            width: 100%;
            margin: 0 auto;
        }

        table.dataTable tbody td {
            height: 50px;
            vertical-align: top;
            padding: 5px 5px 1px 5px;
        }
    </style>
    <div class="pagetitle">
        <h1>Laporan LPBJ</h1>
        <nav>
            <ol class="breadcrumb">

            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <br>
                        <!-- Tabs filter-->
                        <ul class="nav nav-tabs" id="filtertgl" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#f_tgl" type="button" role="tab" aria-controls="lpbj1" aria-selected="true"><i class="bi bi-calendar-month"></i>&nbsp;Filter Tanggal</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#f_brg" type="button" role="tab" aria-controls="profile" aria-selected="false" tabindex="-1"><i class="bi bi-box-seam"></i>&nbsp;Filter Nomor LPBJ</button>
                            </li>
                        </ul>
                        <div class="tab-content pt-2" id="datalpbjdetail">
                            <div class="tab-pane fade active show" id="f_tgl" role="tabpanel" aria-labelledby="home-tab">
                                <div class="row g-3">
                                    <div class="col-md-3">
                                        <label class="form-label">Mulai</label>
                                        <input type="date" class="form-control" id="mulai" value="<?= date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Hingga</label>
                                        <input type="date" class="form-control" id="hingga" value="<?= date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Status</label>
                                        <select class="form-control" id="sts">
                                            <option value="all">Semua</option>
                                            <option value="done">Done</option>
                                            <option value="pending">Pending</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Cabang</label>
                                        <select class="form-control" id="cabang" name="cabang">
                                            <option value="0">All</option>
                                            <?php
                                            $MySQLi = new MySQLi($strDBHostName, $strDBUsername, $strDBPassword, $strDBName);
                                            $query = "select B.label_company,B.company
                                            from tb_akses_company A
                                            Left join tb_company B on B.id_company = A.id_company where A.id_user = " . $_SESSION['id_user'];
                                            $cabang = $MySQLi->query($query);
                                            foreach ($cabang as $c) {
                                                echo "<option value='" . $c['label_company'] . "'>" . $c['company'] . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Barang</label>
                                        <select class="form-control" name="item_id" id="item_id">
                                            <option value="">-- ALL --</option>
                                            <?php
                                            $MySQLi = new MySQLi($strDBHostName, $strDBUsername, $strDBPassword, $strDBName);
                                            $query = "SELECT ID, strDeskripsi FROM item;";
                                            $brg = $MySQLi->query($query);
                                            foreach ($brg as $b) {
                                                echo "<option value='" . $b['ID'] . "'>" . $b['strDeskripsi'] . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-md-12">
                                        <button class="btn btn-primary" id="btnview" style="float:right;margin: 2px;" onclick="tampildata()"><i class='bi bi-search'></i>&nbsp;Lihat LPBJ</button>
                                        <button style="display:none;float:right;margin: 2px;" id="btnloading" class="btn btn-primary" type="button" disabled="">
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            Loading...
                                        </button>
                                    </div>
                                </div><!-- End No Labels Form -->
                            </div>
                            <div class="tab-pane fade" id="f_brg" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="form-label">No LPBJ</label>
                                        <input type="text" name="nolpbj" id="nolpbj" class="form-control">
                                        <!--
                                        <select class="form-control" name="nolpbj" id="nolpbj">
                                            <?php
                                            /*
                                            $akses = "";
                                            switch ($_SESSION['strJenisAkses']) {
                                                case "DIR":
                                                    $akses = "";
                                                    break;
                                                case "MGR":
                                                    $akses = $akses . " AND (employee_Email='" . $_SESSION['strEmail'] . "' OR strMailSPV='" . $_SESSION['strEmail'] . "' OR strMailMGR='" . $_SESSION['strEmail'] . "')";
                                                    break;
                                                case "SPV":
                                                    $akses = $akses . " AND (employee_Email='" . $_SESSION['strEmail'] . "' OR strMailSPV='" . $_SESSION['strEmail'] . "')";
                                                    break;
                                                case "STAFF":
                                                    $akses = $akses . " AND employee_Email='" . $_SESSION['strEmail'] . "'";
                                                    break;
                                            }
                                            $MySQLi = new MySQLi($strDBHostName, $strDBUsername, $strDBPassword, $strDBName);
                                            $query = "select ID,strKdLPBJ FROM tpc_h_lpbj where stsAktif = 1 " . $akses . ";";
                                            $brg = $MySQLi->query($query);
                                            foreach ($brg as $b) {
                                                echo "<option value='" . $b['ID'] . "'>" . $b['strKdLPBJ'] . "</option>";
                                            }
                                                */
                                            ?>
                                        </select>
                                                -->
                                    </div>
                                    <div class="col-md-12">
                                        <button class="btn btn-primary" id="btnviewlpbj" style="float:right;margin: 2px;" onclick="tampildatalpbj()"><i class='bi bi-search'></i>&nbsp;Lihat LPBJ</button>
                                        <button style="display:none;float:right;margin: 2px;" id="btnloadinglpbj" class="btn btn-primary" type="button" disabled="">
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            Loading...
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div><!-- End filter Tabs -->


                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-body">
                        <br>
                        <!-- Default Tabs -->
                        <ul class="nav nav-tabs" id="datalpbj" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#lpbj1" type="button" role="tab" aria-controls="lpbj1" aria-selected="true"><i class="bi bi-file-earmark-post-fill"></i>&nbsp;Laporan</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#lpbj2" type="button" role="tab" aria-controls="profile" aria-selected="false" tabindex="-1"><i class="bi bi-file-earmark-medical"></i>&nbsp;Laporan detail</button>
                            </li>
                        </ul>
                        <div class="tab-content pt-2" id="datalpbjdetail">
                            <div class="tab-pane fade active show" id="lpbj1" role="tabpanel" aria-labelledby="home-tab">
                                <div id="tblpbj1"></div>
                            </div>
                            <div class="tab-pane fade" id="lpbj2" role="tabpanel" aria-labelledby="profile-tab">
                                <div id="tblpbj"></div>
                            </div>
                        </div><!-- End Default Tabs -->

                    </div>
                </div>

            </div>
        </div>
    </section>

</main>

<script>
    $(document).ready(function() {
        $('#example').DataTable();
        $('#item_id').select2({
            width: '100%'
        });
        $('#nolpbj1').select2({
            width: '100%'
        });
    });

    function tampildata() {
        var mulai = $("#mulai").val();
        var hingga = $("#hingga").val();
        var sts = $("#sts").val();
        var item_id = $("#item_id").val();
        var cabang = $("#cabang").val();
        document.getElementById("btnloading").style.display = "block";
        document.getElementById("btnview").style.display = "none";
        $.get("transaksi/persediaan/pemesanan/tb_lpbj.php?mulai=" + mulai + "&hingga=" + hingga + "&sts=" + sts + "&item_id=" + item_id + "&cabang=" + cabang, function(data, status) {
            $("#tblpbj").html(data);
            document.getElementById("btnloading").style.display = "none";
            document.getElementById("btnview").style.display = "block";
        });

        $.get("transaksi/persediaan/pemesanan/tb_lpbj1.php?mulai=" + mulai + "&hingga=" + hingga + "&sts=" + sts + "&item_id=" + item_id + "&cabang=" + cabang, function(data, status) {
            $("#tblpbj1").html(data);
            document.getElementById("btnloading").style.display = "none";
            document.getElementById("btnview").style.display = "block";
        });
    }

    function cetak(id) {
        window.open("transaksi/persediaan/pemesanan/print.pesan.barang.php?ID=" + id, "_blank");
    }

    function tampildatalpbj() {
        var lpbj = $("#nolpbj").val();
        document.getElementById("btnloadinglpbj").style.display = "block";
        document.getElementById("btnviewlpbj").style.display = "none";
        $.get("transaksi/persediaan/pemesanan/tb_lpbj_lpbj.php?id=" + lpbj, function(data, status) {
            $("#tblpbj").html(data);
            document.getElementById("btnloadinglpbj").style.display = "none";
            document.getElementById("btnviewlpbj").style.display = "block";
        });

        $.get("transaksi/persediaan/pemesanan/tb_lpbj1_lpbj.php?id=" + lpbj, function(data, status) {
            $("#tblpbj1").html(data);
            document.getElementById("btnloadinglpbj").style.display = "none";
            document.getElementById("btnviewlpbj").style.display = "block";
        });
    }

    function selesai1(id) {
        Swal.fire({
            title: "Done ?",
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: "Ok, Done",
            //denyButtonText: `Don't save`
        }).then((result) => {
            if (result.isConfirmed) {
                //Swal.fire("Saved!", "", "success");
                $.get("transaksi/persediaan/pemesanan/donepurchase2.php?opt=done&id=" + id, function(data, status) {
                    tampildata();
                });
            }
        });
    }

    function selesai2(id) {
        Swal.fire({
            title: "Done 2 ?",
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: "Ok, Done",
            //denyButtonText: `Don't save`
        }).then((result) => {
            if (result.isConfirmed) {
                //Swal.fire("Saved!", "", "success");
                $.get("transaksi/persediaan/pemesanan/donepurchase3.php?opt=done&id=" + id, function(data, status) {
                    tampildata();
                });
            }
        });
    }
</script>